USE [msdb]
GO

DECLARE @User sysname;
DECLARE @Prefix NVARCHAR(5);
SET @User=N'sa';
SET @Prefix=N'100';

BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0

IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'Data Collector' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'Data Collector'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'ChargoonUnis', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Provides Chargoon compatible data from Unis database', 
		@category_name=N'Data Collector', 
		@owner_login_name=@User, @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'CreateTable', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[Chargoon]'') AND type in (N''U''))
BEGIN
CREATE TABLE [dbo].[Chargoon](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[CardNo] [varchar](16) NULL,
	[DeviceCode] [int] NULL,
	[Year] [int] NULL,
	[Month] [int] NULL,
	[Day] [int] NULL,
	[Hour] [int] NULL,
	[Minute] [int] NULL,
 CONSTRAINT [PK_Chargoon] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N''[dbo].[DF_Chargoon_DeviceCode]'') AND type = ''D'')
BEGIN
ALTER TABLE [dbo].[Chargoon] ADD  CONSTRAINT [DF_Chargoon_DeviceCode]  DEFAULT ((33)) FOR [DeviceCode]
END', 
		@database_name=N'UNIS', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'AddColumn', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'IF NOT EXISTS(
SELECT *
    FROM sys.columns 
    WHERE Name      = N''ReadCounter''
      AND Object_ID = Object_ID(N''tEnter''))
BEGIN
   ALTER TABLE dbo.tEnter ADD ReadCounter INT NOT NULL DEFAULT 0;
END', 
		@database_name=N'UNIS', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

DECLARE @Temp NVARCHAR(MAX);

SET @Temp=N'DECLARE @Temp TABLE
(
	[CardID] bigint,
	[Date] CHAR(8),
	[Time] CHAR(6),
	[DeviceID] int,
	[ReadCounter] tinyint
);

INSERT INTO @Temp ([CardID], [Date], [Time],[DeviceID], [ReadCounter])
SELECT dbo.tEnter.[L_UID], dbo.tEnter.[C_Date], dbo.tEnter.[C_Time], dbo.tEnter.[L_TID], dbo.tEnter.[ReadCounter]
FROM            dbo.tEnter WHERE dbo.tEnter.ReadCounter=0 AND dbo.tEnter.L_UID>=0 AND dbo.tEnter.L_Result=0;

UPDATE dbo.tEnter SET ReadCounter=1 FROM dbo.tEnter INNER JOIN @Temp as T ON dbo.tEnter.L_UID=T.CardID AND
 dbo.tEnter.[C_Date]=T.[Date] AND dbo.tEnter.[C_Time]=T.[Time] AND dbo.tEnter.[L_TID]=T.[DeviceID];

INSERT INTO Chargoon (CardNo,[Year],[Month],[Day],[Hour],[Minute],[DeviceCode])
SELECT N'''+@Prefix+N'''+CAST(T.CardID AS VARCHAR(16)) AS CardNo, SUBSTRING(T.[Date],1,4) AS [Year],SUBSTRING(T.[Date],5,2)  AS [Month],
 SUBSTRING(T.[Date],7,2) AS [Day], SUBSTRING(T.[Time],1,2)  AS [Hour], SUBSTRING(T.[Time],3,2) AS Minute, T.DeviceID FROM @Temp AS T;';

EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Insert', 
		@step_id=3, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=@Temp, 
		@database_name=N'UNIS', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Main', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=4, 
		@freq_subday_interval=10, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20160101, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959, 
		@schedule_uid=N'd92f3511-809c-4b1f-813c-748bc58f6345'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO


